<?php
require_once __DIR__ . '/includes/helpers.php';
$s = site();

function clean(string $v): string {
  $v = trim($v);
  $v = preg_replace('/\r\n|\r|\n/', ' ', $v);
  return $v;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header('Location: /contact.php', true, 302);
  exit;
}

// Time-to-submit (anti-bot): require at least 3 seconds
$tsField = (int)($_POST['ts'] ?? 0);
$age = time() - $tsField;
if ($tsField <= 0 || $age < 3) {
  header('Location: /contact.php?sent=0', true, 302);
  exit;
}

$name = clean((string)($_POST['name'] ?? ''));
$email = clean((string)($_POST['email'] ?? ''));
$phone = clean((string)($_POST['phone'] ?? ''));
$message = trim((string)($_POST['message'] ?? ''));
$consent = (string)($_POST['consent'] ?? '');

if ($name === '' || $email === '' || !filter_var($email, FILTER_VALIDATE_EMAIL) || $phone === '' || $message === '' || $consent !== '1') {
  header('Location: /contact.php?sent=0', true, 302);
  exit;
}

$ip = $_SERVER['REMOTE_ADDR'] ?? '';
$ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
$ts = date('c');

$to = $s['email'];
$subject = 'New website inquiry - ' . $s['brand'];
$body = "INQUIRY\n"
      . "Timestamp: {$ts}\n"
      . "IP: {$ip}\n"
      . "User-Agent: {$ua}\n\n"
      . "Name: {$name}\nEmail: {$email}\nPhone: {$phone}\n\nMessage:\n{$message}\n";

$headers = [];
$headers[] = 'From: ' . $s['brand'] . ' <' . $s['email'] . '>';
$headers[] = 'Reply-To: ' . $email;
$headers[] = 'Content-Type: text/plain; charset=UTF-8';

@mail($to, $subject, $body, implode("\r\n", $headers));
header('Location: /contact.php?sent=1', true, 302);
exit;
