<?php
require_once __DIR__ . '/includes/helpers.php';
$s = site();
$page_title = "Contact" . ($s['defaultTitleSuffix'] ?? '');
$page_description = "Send your details and we will respond quickly with next steps, timeline, and a clear recommendation.";
require __DIR__ . '/includes/header.php';
?>
<main id="main">
  <section class="hero">
    <div class="hero__bg" aria-hidden="true"></div>
    <div class="container hero__grid">
      <div>
        <div class="kicker"><span class="kicker__dot" aria-hidden="true"></span>Lets talk</div>
        <h1>Get in touch</h1>
        <p class="lead">Send your details and we will respond quickly with next steps, timeline, and a clear recommendation.</p>
        <div class="hero__actions">
          <a class="btn btn--primary btn--glow" href="#quote">Get My Free Quote</a>
          <a class="btn" href="/company.php">About the team</a>
        </div>
        <p class="hero__note">SEO-first build. Clean code. Fast pages. Room to scale.</p>
      </div>

      <?php require __DIR__ . '/includes/quote-mini.php'; ?>
    </div>
  </section>

  <section class="page">
    <div class="container">
      <?php breadcrumb("Contact"); ?>

      <div class="split">
        <div>
          <h2>Overview</h2>
          <p>Send your details and we will respond quickly with next steps, timeline, and a clear recommendation.</p>
          <p class="muted">Skeleton content for design review. After layout approval, we can expand copy, FAQs, proof, and case studies.</p>
        </div>
        <div class="callout">
          <h3 style="margin-top:0;">Fastest path to results</h3>
          <p class="muted">Tell us your goal, service area, and timeline. We will recommend the shortest path to ROI.</p>
          <a class="btn btn--primary btn--glow" href="#quote">Get My Free Quote</a>
        </div>
      </div>
    </div>
  </section>

  <section class="section reveal">
    <div class="container">
      <h2>How we work</h2>
      <div class="cards">
        <div class="card"><div class="card__icon" aria-hidden="true">A</div><h3>Audit</h3><p>We map your offer, competitors, and quick wins.</p></div>
        <div class="card"><div class="card__icon" aria-hidden="true">B</div><h3>Build</h3><p>We ship: pages, tracking, creative, automations, and systems.</p></div>
        <div class="card"><div class="card__icon" aria-hidden="true">C</div><h3>Compound</h3><p>We iterate using data: CTR, CVR, calls, and booked revenue.</p></div>
      </div>
    </div>
  </section>

  <section class="section section--alt reveal">
  <div class="container">
    <h2>Contact form</h2>
    <form method="post" action="/contact-submit.php" novalidate data-validate>
      <input type="hidden" name="ts" value="<?= h((string)time()) ?>">
      <div class="field">
        <label for="name">Name *</label>
        <input id="name" name="name" type="text" autocomplete="name" required>
      </div>
      <div class="field">
        <label for="email">Email *</label>
        <input id="email" name="email" type="email" autocomplete="email" required>
      </div>
      <div class="field">
        <label for="phone">Phone *</label>
        <input id="phone" name="phone" type="tel" autocomplete="tel" required>
      </div>
      <div class="field">
        <label for="message">What can we help with? *</label>
        <textarea id="message" name="message" required></textarea>
      </div>

      <label class="quote__consent" style="margin-top:14px;">
        <input type="checkbox" name="consent" value="1" required>
        <span>
          I agree to the <a href="/terms.php">Terms</a> and consent to be contacted about my inquiry,
          including by automated technology and AI-assisted representatives. Consent is not required to purchase.
        </span>
      </label>

      <button class="btn btn--primary btn--glow" type="submit">Send message</button>
      <p class="muted">Prefer fastest response? Use the quote form above.</p>
    </form>
  </div>
</section>
</main>
<?php require __DIR__ . '/includes/footer.php'; ?>
