<?php
require_once __DIR__ . '/includes/helpers.php';
$s = site();
$page_title = "Facebook Marketing" . ($s['defaultTitleSuffix'] ?? '');
$page_description = "Lead funnels, landing pages, and remarketing for consistent pipeline.";
require __DIR__ . '/includes/header.php';
?>
<main id="main">
  <section class="hero">
    <div class="hero__bg" aria-hidden="true"></div>
    <div class="container hero__grid">
      <div>
        <div class="kicker"><span class="kicker__dot" aria-hidden="true"></span>Local reach</div>
        <h1>Facebook ads and retargeting</h1>
        <p class="lead">Lead funnels, landing pages, and remarketing for consistent pipeline.</p>
        <div class="hero__actions">
          <a class="btn btn--primary btn--glow" href="#quote">Get My Free Quote</a>
          <a class="btn" href="/company.php">About the team</a>
        </div>
        <p class="hero__note">SEO-first build. Clean code. Fast pages. Room to scale.</p>
      </div>

      <?php require __DIR__ . '/includes/quote-mini.php'; ?>
    </div>
  </section>

  <section class="page">
    <div class="container">
      <?php breadcrumb("Facebook Marketing"); ?>

      <div class="split">
        <div>
          <h2>Overview</h2>
          <p>Lead funnels, landing pages, and remarketing for consistent pipeline.</p>
          <p class="muted">Skeleton content for design review. After layout approval, we can expand copy, FAQs, proof, and case studies.</p>
        </div>
        <div class="callout">
          <h3 style="margin-top:0;">Fastest path to results</h3>
          <p class="muted">Tell us your goal, service area, and timeline. We will recommend the shortest path to ROI.</p>
          <a class="btn btn--primary btn--glow" href="#quote">Get My Free Quote</a>
        </div>
      </div>
    </div>
  </section>

  <section class="section reveal">
    <div class="container">
      <h2>How we work</h2>
      <div class="cards">
        <div class="card"><div class="card__icon" aria-hidden="true">A</div><h3>Audit</h3><p>We map your offer, competitors, and quick wins.</p></div>
        <div class="card"><div class="card__icon" aria-hidden="true">B</div><h3>Build</h3><p>We ship: pages, tracking, creative, automations, and systems.</p></div>
        <div class="card"><div class="card__icon" aria-hidden="true">C</div><h3>Compound</h3><p>We iterate using data: CTR, CVR, calls, and booked revenue.</p></div>
      </div>
    </div>
  </section>

  
</main>
<?php require __DIR__ . '/includes/footer.php'; ?>
