<?php
require_once __DIR__ . '/helpers.php';
$s = site();

$page_title = $page_title ?? ($s['brand'] . $s['defaultTitleSuffix']);
$page_description = $page_description ?? $s['defaultDescription'];
$body_class = $body_class ?? '';
$header_exclude = $header_exclude ?? ['Home', 'Company', 'Contact']; // as requested for header only
$header_nav = nav_filter(nav_tree(), $header_exclude);
?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= h($page_title) ?></title>
  <meta name="description" content="<?= h($page_description) ?>">
  <link rel="stylesheet" href="/assets/css/styles.css?v=4">
  <script defer src="/assets/js/main.js?v=4"></script>
</head>
<body class="<?= h($body_class) ?>">
<a class="skip-link" href="#main">Skip to content</a>

<header class="site-header" data-header>
  <div class="container site-header__inner">
    <a class="brand" href="/index.php" aria-label="<?= h($s['brand']) ?> home">
      <?php if (!empty($s['logoPath'])): ?>
        <img class="brand__logo" src="<?= h($s['logoPath']) ?>" alt="<?= h($s['logoAlt'] ?? $s['brand']) ?>" loading="eager" decoding="async">
      <?php else: ?>
        <span class="brand__mark" aria-hidden="true"></span>
      <?php endif; ?>

      <span class="brand__text">
        <span class="brand__name"><?= h($s['brand']) ?></span>
        <span class="brand__tag"><?= h($s['tagline']) ?></span>
      </span>
    </a>

    <nav class="nav" aria-label="Primary navigation" data-nav>
      <button class="nav__mobile-btn" type="button" aria-label="Open menu" aria-expanded="false" data-nav-toggle>
        <span class="nav__hamburger" aria-hidden="true"></span>
      </button>

      <div class="nav__panel" data-nav-panel>
        <?php render_nav($header_nav); ?>
        <div class="nav__cta">
          <a class="btn btn--primary btn--glow" href="<?= h($s['primaryCtaHref']) ?>"><?= h($s['primaryCtaText']) ?></a>
        </div>
      </div>
    </nav>
  </div>
  <div class="site-header__hairline" aria-hidden="true"></div>
</header>
