<?php
function site(): array {
  static $s = null;
  if ($s === null) { $s = require __DIR__ . '/site.php'; }
  return $s;
}

function nav_tree(): array {
  static $n = null;
  if ($n === null) { $n = require __DIR__ . '/nav.php'; }
  return $n;
}

function current_path(): string {
  $uri = $_SERVER['REQUEST_URI'] ?? '/';
  $path = parse_url($uri, PHP_URL_PATH) ?: '/';
  if ($path !== '/' && str_ends_with($path, '/')) { $path = rtrim($path, '/'); }
  return $path;
}

function h(string $s): string { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

function is_active(string $href): bool {
  $p = current_path();
  if ($href === '/index.php' && ($p === '/' || $p === '/index.php')) return true;
  return $p === $href;
}

function nav_has_active_child(array $item): bool {
  if (!isset($item['children']) || !is_array($item['children'])) return false;
  foreach ($item['children'] as $child) {
    if (isset($child['href']) && is_active($child['href'])) return true;
  }
  return false;
}

function nav_filter(array $items, array $excludeLabels = []): array {
  $out = [];
  foreach ($items as $item) {
    $label = $item['label'] ?? '';
    if (in_array($label, $excludeLabels, true)) continue;
    $copy = $item;
    if (isset($copy['children']) && is_array($copy['children'])) {
      $copy['children'] = nav_filter($copy['children'], $excludeLabels);
    }
    $out[] = $copy;
  }
  return $out;
}

function render_nav(array $items, bool $isSub = false): void {
  $ulClass = $isSub ? 'nav__submenu' : 'nav__list';
  echo '<ul class="' . h($ulClass) . '">';
  foreach ($items as $item) {
    $label = $item['label'] ?? 'Link';
    $href  = $item['href'] ?? '#';
    $hasChildren = isset($item['children']) && is_array($item['children']) && count($item['children']) > 0;
    $active = is_active($href) || nav_has_active_child($item);
    $liClass = 'nav__item' . ($hasChildren ? ' nav__item--has-children' : '') . ($active ? ' is-active' : '');
    echo '<li class="' . h($liClass) . '">';
    echo '<a class="nav__link" href="' . h($href) . '">' . h($label) . '</a>';
    if ($hasChildren) {
      echo '<button class="nav__toggle" type="button" aria-haspopup="true" aria-expanded="false" aria-label="Open submenu"></button>';
      render_nav($item['children'], true);
    }
    echo '</li>';
  }
  echo '</ul>';
}

function year(): string { return date('Y'); }

function breadcrumb(string $title): void {
  echo '<nav class="breadcrumb" aria-label="Breadcrumb">';
  echo '<a href="/index.php">Home</a>';
  echo '<span aria-hidden="true">/</span>';
  echo '<span>' . h($title) . '</span>';
  echo '</nav>';
}
