<?php
// Mini quote form shown above the fold. Review compliance language with counsel.
?>
<aside class="hero__card quote reveal" data-quote>
  <div class="quote__top">
    <div class="quote__headline">
      <h2 class="quote__title">Turn clicks into calls</h2>
      <p class="quote__sub">Free quote + a clear plan in 24 hours.</p>
    </div>

    <button class="quote__pill" type="button" data-quote-toggle aria-expanded="false">
      Get My Free Quote
    </button>
  </div>

  <div class="quote__body" id="quote">
    <form class="quote__form" method="post" action="/quote-submit.php" novalidate data-validate>
      <input type="hidden" name="ts" value="<?= h((string)time()) ?>">

      <div class="quote__grid2">
        <label class="quote__field">
          <span>Name *</span>
          <input name="name" type="text" autocomplete="name" required>
        </label>
        <label class="quote__field">
          <span>Email *</span>
          <input name="email" type="email" autocomplete="email" required>
        </label>
      </div>

      <div class="quote__grid2">
        <label class="quote__field">
          <span>Phone *</span>
          <input name="phone" type="tel" autocomplete="tel" required>
        </label>
        <label class="quote__field">
          <span>Company (optional)</span>
          <input name="company" type="text" autocomplete="organization">
        </label>
      </div>

      <details class="quote__details">
        <summary>Add details (optional)</summary>

        <fieldset class="quote__fieldset">
          <legend>Interested in</legend>
          <div class="quote__checks">
            <label><input type="checkbox" name="interest[]" value="SEO"> SEO</label>
            <label><input type="checkbox" name="interest[]" value="Website Design"> Website Design</label>
            <label><input type="checkbox" name="interest[]" value="Paid Search"> Paid Search</label>
            <label><input type="checkbox" name="interest[]" value="GBP / Local"> GBP / Local</label>
            <label><input type="checkbox" name="interest[]" value="Ecommerce"> Ecommerce</label>
            <label><input type="checkbox" name="interest[]" value="AI Receptionist"> AI Receptionist</label>
          </div>
        </fieldset>

        <fieldset class="quote__fieldset">
          <legend>Budget</legend>
          <div class="quote__checks">
            <label><input type="radio" name="budget" value="Under 2500"> Under $2,500</label>
            <label><input type="radio" name="budget" value="2500-7500"> $2,500-$7,500</label>
            <label><input type="radio" name="budget" value="7500-15000"> $7,500-$15,000</label>
            <label><input type="radio" name="budget" value="15000+"> $15,000+</label>
          </div>
        </fieldset>

        <label class="quote__field">
          <span>Comments</span>
          <textarea name="comments" rows="3" placeholder="What are you trying to accomplish?"></textarea>
        </label>
      </details>

      <div class="quote__hp" aria-hidden="true">
        <label>Leave this field empty <input name="website" tabindex="-1" autocomplete="off"></label>
      </div>

      <label class="quote__consent">
        <input type="checkbox" name="consent" value="1" required>
        <span>
          I agree to the <a href="/terms.php">Terms</a> and consent to be contacted about my inquiry,
          including by automated technology and AI-assisted representatives. Consent is not required to purchase.
        </span>
      </label>

      <button class="btn btn--primary quote__btn" type="submit">GET MY FREE QUOTE</button>
      <p class="quote__micro">Response within 1 business day. We never sell your info.</p>
    </form>
  </div>
</aside>
