<?php
require_once __DIR__ . '/includes/helpers.php';
$s = site();
$page_title = $s['brand'] . $s['defaultTitleSuffix'];
$page_description = $s['defaultDescription'];
require __DIR__ . '/includes/header.php';
?>
<main id="main">
  <section class="hero">
    <div class="hero__bg" aria-hidden="true"></div>
    <div class="container hero__grid">
      <div>
        <div class="kicker"><span class="kicker__dot" aria-hidden="true"></span>SEO-first. Design-led. Engineering-backed.</div>
        <h1>Launch a modern brand with an unfair local advantage.</h1>
        <p class="lead">
          SEO, web, paid search, content, and AI-driven workflows designed to turn attention into booked revenue.
        </p>
        <div class="hero__actions">
          <a class="btn btn--primary btn--glow" href="#quote">Get My Free Quote</a>
          <a class="btn" href="/results.php">See results</a>
        </div>
        <p class="hero__note">Built to scale without a CMS: lean PHP includes + fast, clean HTML.</p>
      </div>

      <?php require __DIR__ . '/includes/quote-mini.php'; ?>
    </div>
  </section>

  <!-- Video section (text left, video right) -->
  <section class="section reveal">
    <div class="container media-split">
      <div>
        <h2>What we do (in plain English)</h2>
        <p class="lead">If you're investing in growth, you need a system that turns clicks into calls, calls into appointments, and appointments into revenue.</p>
        <ul>
          <li><strong>SEO:</strong> local + national visibility that compounds</li>
          <li><strong>Paid search:</strong> fast lead flow with measurable ROI</li>
          <li><strong>Web:</strong> conversion-first design that builds trust immediately</li>
          <li><strong>AI reception:</strong> capture leads after hours and follow up faster</li>
        </ul>
        <a class="btn btn--primary btn--glow" href="#quote">Get My Free Quote</a>
      </div>

      <div class="video-frame">
        <div class="video-frame__inner">
          <?php if (!empty($s['homeVideoEmbedUrl'])): ?>
            <iframe
              src="<?= h($s['homeVideoEmbedUrl']) ?>"
              title="Immersify Digital overview video"
              loading="lazy"
              referrerpolicy="no-referrer-when-downgrade"
              allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
              allowfullscreen></iframe>
          <?php else: ?>
            <div>Homepage video placeholder (embed URL in includes/site.php)</div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </section>

  <section class="section section--alt reveal">
    <div class="container">
      <h2>Core services</h2>
      <p class="muted">Starter content for design review. We will build full page-by-page copy next.</p>
      <div class="cards">
        <div class="card">
          <div class="card__icon" aria-hidden="true">SEO</div>
          <h3>SEO</h3>
          <p>Local + national SEO, audits, on-page, backlinks, and GBP optimization.</p>
        </div>
        <div class="card">
          <div class="card__icon" aria-hidden="true">ADS</div>
          <h3>Paid Search</h3>
          <p>Google + Meta + social campaigns with landing pages built to convert.</p>
        </div>
        <div class="card">
          <div class="card__icon" aria-hidden="true">AI</div>
          <h3>AI Reception</h3>
          <p>AI-assisted receptionist workflows and follow-up to reduce lead leakage.</p>
        </div>
      </div>
    </div>
  </section>

  <!-- Testimonials -->
  <section class="section reveal">
    <div class="container">
      <h2>Testimonials</h2>
      <p class="muted">Placeholders for now. We'll replace with real quotes, names (or initials), and optional video embeds.</p>

      <div class="testimonials">
        <div class="testimonial">
          <p><strong>"We started getting calls within weeks."</strong></p>
          <p class="muted">Local SEO + GBP cleanup + better service pages. The lead quality improved immediately.</p>
          <div class="testimonial__meta">
            <span>— Client (placeholder)</span>
            <span>Local SEO</span>
          </div>
        </div>

        <div class="testimonial">
          <p><strong>"The website looks premium and converts."</strong></p>
          <p class="muted">Clear offer, trust elements, and a quote form that actually gets completed.</p>
          <div class="testimonial__meta">
            <span>— Client (placeholder)</span>
            <span>Web + CRO</span>
          </div>
        </div>

        <div class="testimonial">
          <p><strong>"Paid search became predictable."</strong></p>
          <p class="muted">Better landing pages, tighter tracking, and weekly optimization to lower CPA.</p>
          <div class="testimonial__meta">
            <span>— Client (placeholder)</span>
            <span>Paid Search</span>
          </div>

          <div class="testimonial__video">
            <div class="video-frame__inner">Video testimonial placeholder</div>
          </div>
        </div>
      </div>

      <div style="margin-top:16px;">
        <a class="btn btn--primary btn--glow" href="/results.php">See results</a>
      </div>
    </div>
  </section>
</main>
<?php require __DIR__ . '/includes/footer.php'; ?>
