<?php
require_once __DIR__ . '/includes/helpers.php';
$s = site();

function clean_line(string $v): string {
  $v = trim($v);
  $v = preg_replace('/\r\n|\r|\n/', ' ', $v);
  return $v;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header('Location: /index.php', true, 302);
  exit;
}

// Honeypot
if (!empty($_POST['website'] ?? '')) {
  header('Location: /index.php', true, 302);
  exit;
}

// Time-to-submit (anti-bot): require at least 3 seconds
$tsField = (int)($_POST['ts'] ?? 0);
$age = time() - $tsField;
if ($tsField <= 0 || $age < 3) {
  header('Location: /index.php#quote', true, 302);
  exit;
}

$name = clean_line((string)($_POST['name'] ?? ''));
$email = clean_line((string)($_POST['email'] ?? ''));
$phone = clean_line((string)($_POST['phone'] ?? ''));
$company = clean_line((string)($_POST['company'] ?? ''));
$budget = clean_line((string)($_POST['budget'] ?? ''));
$comments = trim((string)($_POST['comments'] ?? ''));
$consent = (string)($_POST['consent'] ?? '');
$interest = $_POST['interest'] ?? [];
if (!is_array($interest)) $interest = [];

$errors = [];
if ($name === '') $errors[] = 'Name is required.';
if ($email === '' || !filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = 'A valid email is required.';
if ($phone === '') $errors[] = 'Phone is required.';
if ($consent !== '1') $errors[] = 'Consent is required.';

if ($errors) {
  header('Location: /index.php#quote', true, 302);
  exit;
}

$ip = $_SERVER['REMOTE_ADDR'] ?? '';
$ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
$ts = date('c');

$to = $s['email'];
$subject = 'New FREE QUOTE request - ' . $s['brand'];
$body = "FREE QUOTE REQUEST\n"
      . "Timestamp: {$ts}\n"
      . "IP: {$ip}\n"
      . "User-Agent: {$ua}\n\n"
      . "Name: {$name}\n"
      . "Email: {$email}\n"
      . "Phone: {$phone}\n"
      . "Company: {$company}\n"
      . "Budget: {$budget}\n"
      . "Interests: " . implode(', ', array_map('clean_line', $interest)) . "\n\n"
      . "Comments:\n{$comments}\n";

$headers = [];
$headers[] = 'From: ' . $s['brand'] . ' <' . $s['email'] . '>';
$headers[] = 'Reply-To: ' . $email;
$headers[] = 'Content-Type: text/plain; charset=UTF-8';

@mail($to, $subject, $body, implode("\r\n", $headers));
header('Location: /contact.php?sent=1', true, 302);
exit;
