<?php
require_once __DIR__ . '/includes/helpers.php';
$s = site();
$page_title = 'Results' . ($s['defaultTitleSuffix'] ?? '');
$page_description = 'Websites, graphics, and video results by ' . $s['brand'] . '.';
$items = require __DIR__ . '/includes/portfolio-data.php';
require __DIR__ . '/includes/header.php';

function type_label(string $t): string {
  if ($t === 'website') return 'Websites';
  if ($t === 'graphics') return 'Graphics';
  if ($t === 'video') return 'Videography';
  return 'Work';
}
?>
<main id="main">
  <section class="hero">
    <div class="hero__bg" aria-hidden="true"></div>
    <div class="container hero__grid">
      <div>
        <div class="kicker"><span class="kicker__dot" aria-hidden="true"></span>Proof, not promises</div>
        <h1>Results</h1>
        <p class="lead">Websites, graphics, and video work. Click any thumbnail to view a case study.</p>
        <div class="hero__actions">
          <a class="btn btn--primary btn--glow" href="#quote">Get My Free Quote</a>
          <a class="btn" href="/seo-results.php">SEO results</a>
        </div>
        <p class="hero__note">Placeholders for now. We'll swap in real client work and metrics.</p>
      </div>

      <?php require __DIR__ . '/includes/quote-mini.php'; ?>
    </div>
  </section>

  <section class="page">
    <div class="container">
      <?php breadcrumb('Results'); ?>

      <div class="portfolio-toolbar reveal" role="region" aria-label="Results filters">
        <button class="pill is-active" type="button" data-filter="all">All</button>
        <button class="pill" type="button" data-filter="website">Websites</button>
        <button class="pill" type="button" data-filter="graphics">Graphics</button>
        <button class="pill" type="button" data-filter="video">Videography</button>
      </div>

      <div class="portfolio-grid reveal" data-portfolio-grid>
        <?php foreach ($items as $i):
          $slug = $i['slug'];
          $href = '/' . $slug . '.php';
        ?>
          <a class="portfolio-card" href="<?= h($href) ?>" data-type="<?= h($i['type']) ?>">
            <div class="portfolio-thumb" aria-hidden="true">
              <div class="portfolio-badge"><?= h(type_label($i['type'])) ?></div>
            </div>
            <div class="portfolio-meta">
              <div class="portfolio-title"><?= h($i['title']) ?></div>
              <div class="muted"><?= h($i['tag'] ?? '') ?></div>
              <div class="portfolio-summary muted"><?= h($i['summary'] ?? '') ?></div>
            </div>
          </a>
        <?php endforeach; ?>
      </div>
    </div>
  </section>
</main>
<?php require __DIR__ . '/includes/footer.php'; ?>
