<?php
require_once __DIR__ . '/includes/helpers.php';
$s = site();
$page_title = 'SEO Results' . ($s['defaultTitleSuffix'] ?? '');
$page_description = 'Examples of local and organic SEO results by ' . $s['brand'] . '.';
require __DIR__ . '/includes/header.php';
?>
<main id="main">
  <section class="hero">
    <div class="hero__bg" aria-hidden="true"></div>
    <div class="container hero__grid">
      <div>
        <div class="kicker"><span class="kicker__dot" aria-hidden="true"></span>Rankings + revenue</div>
        <h1>SEO Results</h1>
        <p class="lead">Showcase first-page wins, map visibility, and measurable lead growth. Replace these placeholders with your real screenshots and keywords.</p>
        <div class="hero__actions">
          <a class="btn btn--primary btn--glow" href="#quote">Get My Free Quote</a>
          <a class="btn" href="/results.php">All results</a>
        </div>
      </div>

      <?php require __DIR__ . '/includes/quote-mini.php'; ?>
    </div>
  </section>

  <section class="page">
    <div class="container">
      <?php breadcrumb('SEO Results'); ?>

      <div class="callout reveal">
        <h2 style="margin-top:0;">How to use this page to sell</h2>
        <p class="muted">Add a few before/after screenshots, a keyword list, and a short story of what changed. Prospects buy clarity and proof.</p>
      </div>

      <h2 class="reveal" style="margin-top:18px;">Sample results table (placeholder)</h2>
      <div class="reveal" style="overflow:auto; border:1px solid rgba(11,13,18,.10); border-radius:18px;">
        <table style="width:100%; border-collapse: collapse; min-width: 720px;">
          <thead>
            <tr style="text-align:left; background: rgba(11,13,18,.02);">
              <th style="padding:12px; border-bottom:1px solid rgba(11,13,18,.10);">Keyword</th>
              <th style="padding:12px; border-bottom:1px solid rgba(11,13,18,.10);">Location</th>
              <th style="padding:12px; border-bottom:1px solid rgba(11,13,18,.10);">Result</th>
              <th style="padding:12px; border-bottom:1px solid rgba(11,13,18,.10);">Timeframe</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td style="padding:12px; border-bottom:1px solid rgba(11,13,18,.08);">[service] near me</td>
              <td style="padding:12px; border-bottom:1px solid rgba(11,13,18,.08);">[city, state]</td>
              <td style="padding:12px; border-bottom:1px solid rgba(11,13,18,.08);">Page 1</td>
              <td style="padding:12px; border-bottom:1px solid rgba(11,13,18,.08);">90 days</td>
            </tr>
            <tr>
              <td style="padding:12px; border-bottom:1px solid rgba(11,13,18,.08);">best [service]</td>
              <td style="padding:12px; border-bottom:1px solid rgba(11,13,18,.08);">[city, state]</td>
              <td style="padding:12px; border-bottom:1px solid rgba(11,13,18,.08);">Top 3</td>
              <td style="padding:12px; border-bottom:1px solid rgba(11,13,18,.08);">120 days</td>
            </tr>
            <tr>
              <td style="padding:12px;">[service] [city]</td>
              <td style="padding:12px;">[city, state]</td>
              <td style="padding:12px;">Map Pack Visibility</td>
              <td style="padding:12px;">60 days</td>
            </tr>
          </tbody>
        </table>
      </div>

      <div class="section section--alt reveal" style="padding:28px 0; margin-top:18px;">
        <div class="container">
          <h2>What we did (starter)</h2>
          <div class="cards">
            <div class="card"><div class="card__icon" aria-hidden="true">01</div><h3>Technical cleanup</h3><p>Speed, indexation, internal links, and structure.</p></div>
            <div class="card"><div class="card__icon" aria-hidden="true">02</div><h3>GBP optimization</h3><p>Categories, services, content, photos, and ongoing updates.</p></div>
            <div class="card"><div class="card__icon" aria-hidden="true">03</div><h3>Content + authority</h3><p>Service pages, location pages, and link building (as needed).</p></div>
          </div>
        </div>
      </div>
    </div>
  </section>
</main>
<?php require __DIR__ . '/includes/footer.php'; ?>
